local Player = ...
assert(Player,"[ScreenStageInformation StepInfo] needs a player passed in")

local textC
local mainFont = "_dejavu sans Bold 24px"
local mainZoom = 16/24

return Def.ActorFrame{
	-- base
	LoadActor(THEME:GetPathG("_player","messagebox"))..{
		OffCommand=cmd(bouncebegin,0.25;zoomy,0);
	};

	Def.ActorFrame{
		Name="TextArea";
		InitCommand=function(self) textC = self:GetChildren(); end;
		BeginCommand=function(self)
			local song = SongOrCourse()
			local steps = StepsOrTrail(Player)
			local diffText = "gtfo"
			local meterText = "0"
			local panelText = "[?]"

			if song and steps then
				local st = steps:GetStepsType()
				local diff = steps:GetDifficulty()

				diffText = GetCustomDifficulty(st,diff,nil)
				textC.DifficultyName:diffuse(CustomDifficultyToColor(diffText))
				textC.DifficultyName:shadowcolor( BoostColor(CustomDifficultyToColor(diffText),0.4) )

				meterText = steps:GetMeter()
				textC.DifficultyMeter:diffuse(CustomDifficultyToColor(diffText))
				textC.DifficultyMeter:shadowcolor( BoostColor(CustomDifficultyToColor(diffText),0.4) )

				-- fix for things
				if diff == 'Difficulty_Edit' and steps:GetDescription() ~= "" then
					diffText = steps:GetDescription()
				else
					diffText = CustomDifficultyToLocalizedString(GetCustomDifficulty(st,diff,nil))
				end

				panelText = THEME:GetString("Panel",ToEnumShortString(st))
			else
				diffText = ""
				meterText = ""
				panelText = ""
			end

			textC.DifficultyName:settext(diffText)
			textC.DifficultyMeter:settext(meterText)
			textC.Panels:settext(panelText)
		end;

		LoadFont(mainFont)..{
			Name="Panels";
			InitCommand=cmd(x,-88;y,-16;halign,1;shadowlength,1;diffusebottomedge,color("#BBBBBB");zoom,mainZoom);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
		LoadFont(mainFont)..{
			Name="DifficultyName";
			InitCommand=cmd(x,-84;y,-16;halign,0;shadowlength,1;zoom,mainZoom;uppercase,true);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};
		LoadFont(mainFont)..{
			Name="DifficultyMeter";
			InitCommand=cmd(x,36;y,-16;halign,1;shadowlength,1;zoom,mainZoom);
			OffCommand=cmd(linear,0.2;diffusealpha,0);
		};

		-- sub text area (bpm display, chart creator, ???)
		-- your best score?
	};
};